﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Rozdział_36
{
    class HospitalStaffWithoutIEnumerator : IDisposable
    {
        public string Doctor { get; set; }
        public string Nurse { get; set; }
        public string Intern1 { get; set; }
        public string Intern2 { get; set; }

        private int m_currentPos = -1;
        private string m_currentVal = string.Empty;

        private enum Staff
        {
            Doctor,
            Nurse,
            Intern1,
            Intern2
        }

        public HospitalStaffWithoutIEnumerator GetEnumerator()
        {
            return this;
        }

        public bool MoveNext()
        {
            if (m_currentPos == (int)Staff.Intern2)
            {
                return false;
            }

            ++m_currentPos;

            Staff staffMbr;

            if (Enum.IsDefined(typeof(Staff), m_currentPos))
            {
                staffMbr = (Staff)Enum.ToObject(
                        typeof(Staff), m_currentPos);
            }
            else
            {
                string message =
                        m_currentPos < 0 ?
                        "Wywołanie MoveNext przed odczytem właściwości Current" :
                        "Po odczytaniu wszystkich danych trzeba wywołać Reset lub GetEnumerator";
                throw new IndexOutOfRangeException(message);
            }

            switch (staffMbr)
            {
                case Staff.Doctor:
                    m_currentVal = Doctor;
                    break;
                case Staff.Nurse:
                    m_currentVal = Nurse;
                    break;
                case Staff.Intern1:
                    m_currentVal = Intern1;
                    break;
                case Staff.Intern2:
                    m_currentVal = Intern2;
                    break;
                default:
                    throw new InvalidOperationException(
                        "Ten fragment kodu nie powinien być nigdy wykonany.");
            }

            return true;
        }

        public string Current
        {
            get { return m_currentVal; }
        }

        public void Dispose()
        {
            throw new NotImplementedException();
        }
    }
}
